<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post;

use Erlage\Photogram\Data\Models\AbstractModel;
use Erlage\Photogram\Data\Tables\Post\PostTable;

final class PostModel extends AbstractModel implements InterfacePostGetter
{
    /**
     * getter interface
     */
    use TraitPostGetters;

    public function getTableClassName(): string
    {
        return PostTable::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | override the delete logic
    |--------------------------------------------------------------------------
    */

    public function delete(): bool
    {
        PostModelHelper::deleteDependencies($this);

        // delete the $this as well
        return parent::delete();
    }
}
